const express = require('express')
const app = express()
var cors = require('cors'); // apporte la gestion des requetes CORS multi origin
var mimetype = require('mime-types');
var fs = require('fs');
var inspect = require('util').inspect;
var request = require('request');

const https = require('https');
const http = require('http');
const httpServer = http.createServer(app);
const httpsServer = https.createServer({
    key: fs.readFileSync('privkey.pem'),
    cert: fs.readFileSync('fullchain.pem'),
}, app);

const idclient = "XXXXXXXXXXXXXXXX";
const secretclient = "XXXXXXXXXXXXXXXX";

app.use(cors()) // sans precision dans les appels get post etc = s'applique a toutes les url. Evite le crash lors de passage d'en tete par le client dans des pre requetes OPTIONS
app.use(express.json()); // for parsing application/json
app.use(express.static('assets')); // service de fichier public

app.get('/', function (req, res) {
    res.send('API REST SERVER')
})

// save tokens
function save_tokens(objtoken){
    try {
        fs.writeFileSync('tokens.json', JSON.stringify({
            token_type: objtoken.token_type,
            expires_in: objtoken.expire_in,
            access_token: objtoken.access_token,
            refresh_token: objtoken.refresh_token,
            uptime: new Date()
        }));
    } catch (err) {
        console.error(err);
    }
}

// avec code pour echange token
/*
L'appel de la page suivante dans le navigateur permet de demarrer le processus d'authentification oauth2.

https://focus.teamleader.eu/oauth2/authorize?client_id=XXXXXXXXXXXXXXXX&client_secret=XXXXXXXXXXXXXXXX&response_type=code&redirect_uri=https://XXXXXXXXXXXXXXXX/redirect

Lors de la validation du formulaire, la page redirect est appellé avec un code a echanger contre un token.
La methode request.post se charge de cet echange. En retour nous obtenons un token utilisable et un refrsh token permettant de garder active la demande.
*/
app.get('/redirect', (req,res, next) => {
    let objpost = {
        client_id: idclient,
        client_secret: secretclient,
        grant_type: 'authorization_code',
        code: req.query.code,
        redirect_uri: 'https://XXXXXXXXXXXXXXXX/redirect',
    };
    request.post({
        headers: {'content-type': 'application/x-www-form-urlencoded'},
        url: 'https://focus.teamleader.eu/oauth2/access_token',
        method: 'POST',
        form: objpost
    }, function (err, res2, body) {
        if (err) console.log(err);
        let objtoken = JSON.parse(body);
        res.setHeader('Content-Type', 'text/html; charset=utf-8');
        res.end(`
            <html><head>
            <title></title>
            </head><body>
            <h2>Information sur le token</h2>
              token_type: ${objtoken.token_type},<br>
              expires_in: ${objtoken.expire_in},<br>
              access_token: ${objtoken.access_token}<br>
             <h2>Lien permettant le rafraichissement du token</h2>
              <a href="https://XXXXXXXXXXXXXXXX/refresh?refresh_token=${objtoken.refresh_token}">REFRESH LINK</a>
            </body></html>
        `);
        save_tokens(objtoken);
    });
});

/*
L'appel de la page

https://XXXXXXXXXXXXXXXX/refresh?refresh_token=XXXXXXXXXXXXXXXX

Permet de regénérer un token une fois l'heure de validité expirer. Le code de refresh token reste actif indéfiniment tant que l'utilisateur ne la pas revoquer ou que l'application n'est pas supprimer du marketplace teamleader.
 */
app.get('/refresh', (req,res, next) => {
    let objpost = {
        client_id: idclient,
        client_secret: secretclient,
        grant_type: 'refresh_token',
        refresh_token: req.query.refresh_token,
    };
    request.post({
        headers: {'content-type': 'application/x-www-form-urlencoded'},
        url: 'https://focus.teamleader.eu/oauth2/access_token',
        method: 'POST',
        form: objpost
    }, function (err, res2, body) {
        if (err) console.log(err);
        let objtoken = JSON.parse(body);
        res.setHeader('Content-Type', 'text/html; charset=utf-8');
        res.end(`
            <html><head>
            <title></title>
            </head><body>
            <h2>Information sur le token</h2>
              token_type: ${objtoken.token_type},<br>
              expires_in: ${objtoken.expire_in},<br>
              access_token: ${objtoken.access_token}<br>
             <h2>Lien permettant le rafraichissement du token</h2>
              <a href="https://XXXXXXXXXXXXXXXX/refresh?refresh_token=${objtoken.refresh_token}">REFRESH LINK</a>
            </body></html>
        `);
        save_tokens(objtoken);
    });
});

httpsServer.listen(443, () => {
    console.log('HTTPS Server running on port 443');
});
